package gov.va.med.mhv.calendar.service;

import gov.va.med.mhv.calendar.dto.ReminderDTO;
import gov.va.med.mhv.common.api.exception.MHVException;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

@Path("/")
@Service("reminderService")
public interface ReminderService {
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("finderRemindersByDto/{userProfileId}")
	public List<ReminderDTO> finderRemindersByUserProfile(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("findRemindersByUserProfileAndSentState/{userProfileId}/{reminderSent}")
	public List<ReminderDTO> findRemindersByUserProfileAndSentState(@PathParam("userProfileId") Long userProfileId, @PathParam("reminderSent") Boolean reminderSent) throws MHVException;

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/saveReminder")
	public void saveReminder(ReminderDTO reminderDto) throws MHVException;
	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/deleteReminder/{reminderId}")
	public void deleteReminder(@PathParam("reminderId") Long reminderId) throws MHVException;
	
}
